/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class PatchHandler
implements Handler {
    private Directory directory;
    private JsonPatchParser jsonPatchParser;

    public PatchHandler(Directory directory, JsonPatchParser jsonPatchParser) {
        this.directory = directory;
        this.jsonPatchParser = jsonPatchParser;
    }

    @Override
    public Response generateResponse(Request request) {
        try {
            String requestContentType = request.getHeader("Content-Type");
            if (!this.directory.existsInStore(request.getURI()).booleanValue()) {
                return new Response.Builder(404).build();
            }
            if (!requestContentType.equals("application/json-patch+json")) {
                return new Response.Builder(415).setHeader("Accept-Patch", "application/json-patch+json").build();
            }
            String updatedResourceContent = this.getUpdatedResourceContent(request);
            this.directory.overwriteFileWithContent(request.getURI(), updatedResourceContent.getBytes());
            return this.buildOkResponse(request);
        }
        catch (BadRequestException e) {
            return new Response.Builder(400).build();
        }
        catch (UnprocessableEntityException e) {
            return new Response.Builder(422).build();
        }
    }

    private String getUpdatedResourceContent(Request request) throws BadRequestException, UnprocessableEntityException {
        String uri = request.getURI();
        String updatedResourceContent = new String(this.directory.readFile(uri));
        ArrayList<JsonPatchOperation> patches = this.jsonPatchParser.getOperations(request.getBody());
        for (JsonPatchOperation patch : patches) {
            updatedResourceContent = patch.applyOperation(updatedResourceContent);
        }
        return updatedResourceContent;
    }

    private Response buildOkResponse(Request request) {
        String uri = request.getURI();
        String fileContent = new String(this.directory.readFile(uri));
        return new Response.Builder(200).messageBody(fileContent).setHeader("Content-Type", "application/json").build();
    }
}

