/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class NotFoundHandler
implements Handler {
    private Directory directory;

    public NotFoundHandler(Directory directory) {
        this.directory = directory;
    }

    @Override
    public Response generateResponse(Request request) {
        switch (request.getMethod()) {
            case "OPTIONS": {
                return this.handleOptionsRequest(request);
            }
            case "PUT": {
                return this.handlePutResponse(request);
            }
        }
        return this.buildNotFoundResponse(request.getURI());
    }

    private Response handleOptionsRequest(Request request) {
        List<String> supportedMethods = this.getSupportedMethods(request.getURI());
        return ResponseUtil.buildOptionsResponse(supportedMethods);
    }

    private List<String> getSupportedMethods(String uri) {
        ArrayList<String> supportedMethods = new ArrayList<String>();
        supportedMethods.add("OPTIONS");
        if (this.isPutable(uri)) {
            supportedMethods.add("PUT");
        }
        return supportedMethods;
    }

    private boolean isPutable(String uri) {
        String fileType = this.directory.getFileType(uri);
        return fileType.equals("application/json") || fileType.equals("text/plain");
    }

    private Response handlePutResponse(Request request) {
        return this.createFile(request) ? this.buildPutResponse() : this.buildInternalServerErrorResponse();
    }

    private boolean createFile(Request request) {
        byte[] fileContent = request.getBody().getBytes();
        return this.directory.createFileWithContent(request.getURI(), fileContent);
    }

    private Response buildPutResponse() {
        return new Response.Builder(201).messageBody(this.createPutMessageBody()).build();
    }

    private String createPutMessageBody() {
        return "That file didn't exist before, so I've created it for you.";
    }

    private Response buildInternalServerErrorResponse() {
        return new Response.Builder(500).build();
    }

    private Response buildNotFoundResponse(String uri) {
        return new Response.Builder(404).messageBody(this.createNotFoundMessageBody(uri)).build();
    }

    private String createNotFoundMessageBody(String uri) {
        return uri + " was not found!";
    }
}

