/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FormHandler
implements Handler {
    private static final String DESTINATION_DIRECTORY_URI = "/POSTed";
    private static final String POSTED_FILE_EXTENSION = ".txt";
    private static final List<String> SUPPORTED_METHODS = Arrays.asList("OPTIONS", "POST");
    private Directory directory;

    public FormHandler(Directory directory) {
        this.directory = directory;
        this.directory.createDirectory(DESTINATION_DIRECTORY_URI);
    }

    @Override
    public Response generateResponse(Request request) {
        switch (request.getMethod()) {
            case "OPTIONS": {
                return ResponseUtil.buildOptionsResponse(SUPPORTED_METHODS);
            }
            case "POST": {
                return this.buildPostResponse(request);
            }
        }
        return ResponseUtil.buildMethodNotAllowedResponse(SUPPORTED_METHODS);
    }

    private Response buildPostResponse(Request request) {
        try {
            String uri = "/POSTed/" + Util.createRandomFileName(POSTED_FILE_EXTENSION);
            byte[] content = this.createFileContent(request);
            this.directory.createFileWithContent(uri, content);
            return new Response.Builder(303).setHeader("Location", uri).build();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new Response.Builder(400).build();
        }
    }

    private byte[] createFileContent(Request request) throws ArrayIndexOutOfBoundsException {
        Object content = "Thank you for submitting the following data:\n";
        HashMap<String, String> bodyKeyValPairs = this.extractKeyValPairsFromBody(request.getBody());
        content = (String)content + this.stringifyKeyValPairs(bodyKeyValPairs);
        return ((String)content).getBytes();
    }

    private HashMap<String, String> extractKeyValPairsFromBody(String body) throws ArrayIndexOutOfBoundsException {
        String[] splitBody;
        HashMap<String, String> keyValPairs = new HashMap<String, String>();
        for (String keyValPair : splitBody = body.split("&")) {
            String[] splitKeyValPair = keyValPair.split("=");
            String key = splitKeyValPair[0];
            String val = splitKeyValPair[1];
            keyValPairs.put(key, val);
        }
        return keyValPairs;
    }

    private String stringifyKeyValPairs(HashMap<String, String> keyValPairs) {
        Object result = "";
        for (Map.Entry<String, String> entry : keyValPairs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            result = (String)result + key + ": " + value + "\n";
        }
        return result;
    }
}

