(ns datomscript.core.spec
  (:require   
   #?@(:clj [[clojure.spec :as s]
             [clojure.tools.logging :as log]])
   #?@(:cljs [[cljs.spec :as s]
              [datascript.core]
              [datascript.db]])))

(def entity-status #{:added :removed :updated})

(def long? #(instance? #?(:clj java.lang.Long
                          :cljs js/Number)
                       %))

(def db? #?(:clj #(instance? datomic.db.Db %)
            :cljs #(satisfies? datascript.db/IDB %)))

(def conn? #?(:clj #(instance? datomic.peer.Connection %)
              :cljs #(satisfies? datascript.db/IDB %)))

(s/def :datomscript/db db?)

(s/def :datomscript/conn conn?)

;; Should be vector of datoms

(s/def :datomscript/db-after :datomscript/db)

(s/def :datomscript/db-before :datomscript/db)

(s/def :datomscript/tx-data
  (s/or
    :vector vector?
    #?(:clj :array-list) #?(:clj #(instance? java.util.ArrayList %))))

(s/def :datomscript/tempids map?)

(s/def :datomscript/tx-report
  (s/keys :req-un [:datomscript/db-after
                :datomscript/db-before
                :datomscript/tx-data
                :datomscript/tempids]))

(s/def :datomscript/entity-classification
  (s/coll-of (s/cat :entity long? :entity-status entity-status)
    #{}))

(s/def :datomscript/req-tx-data
  (s/or
    :vector vector?
    #?(:clj :array-list) #?(:clj #(instance? java.util.ArrayList %))))

(s/def :datomscript/post-tx-handlers map?)

(s/def :datomscript/permission-handlers map?)

(s/def :datomscript/access-token
  (s/or :hash-map map? #?(:clj :entity) #?(:clj #(instance? datomic.query.EntityMap %)) ))

(def boolean? #(or (true? %) (false? %)))

(s/def :datomscript/skip-permissions? boolean?)

(s/def :datomscript.tx-map/base-params
  (s/keys
    :req-un [:datomscript/conn
             :datomscript/req-tx-data
             :datomscript/skip-permissions?
             :datomscript/post-tx-handlers
             :datomscript/permission-handlers]
    :opt-un [:datomscript/access-token]))

(s/def :datomscript/model-type keyword?)

(s/def :datomscript.delta/model
  (s/or :nil nil? :map (s/keys
                         :req-un [:datomscript/model-type]
                         :opt-un [:datomscript/access-token])))

(s/def :datomscript.delta/new :datomscript.delta/model)

(s/def :datomscript.delta/old :datomscript.delta/model)

(s/def :datomscript/delta
  (s/keys :req-un [:datomscript.delta/old
                   :datomscript.delta/new]))

(s/def :datomscript/deltas
  (s/+ :datomscript/delta))


(def uuid? 
  #?(:clj #(instance? java.util.UUID %)
     :cljs #(instance? cljs.core.UUID %)))

(def tempid? 
  #?(:clj #(instance? datomic.db.DbId %)
     :cljs (s/and number? #(< % 0))))

(def date?
  #?(:clj #(instance? java.util.Date %)
     :cljs #(= (type %) js/Date)))

;; Still need to deal with om id
;; Probably using a protocol like is-db-id? that can be implemented
(s/def :db/id (s/or :long long? :tempid tempid?))

(s/def :resource/eid uuid?)

(s/def :db/txInstant date?)
