(ns datomscript.core.schema
  (:require
   [datomscript.core.model]
   [datomscript.core.spec]
   #?@(:clj [[clojure.spec :as s]]
       :cljs [[cljs.spec :as s]])))

(def schema
  {:model/type {:db/cardinality :db.cardinality/one
                :db/index true
                :db/valueType :db.type/ref}
   :resource/eid {:db/cardinality :db.cardinality/one
                  :db/valueType :db.type/uuid
                  :db/unique :db.unique/identity}})

#?(:clj
   (def migration
     {:datomscript/schema
      {:txes [(datomscript.core.model/install-schema
                schema)]}}))

