(ns datomscript.client.om.view
  (:require [om.next :as om :refer-macros [defui]]
            [om.dom :as dom]))

(defn text-links [text-link]
  (map
    (fn [[i t]]
      (if (string? t)
        t
        (dom/a #js {:key (str i)
                    :href (:href t)} (:text t))))
    (map-indexed vector text-link)))

(defn widget-factory [view-fn]
  (om/factory view-fn
    {:keyfn (fn [x] (or
                      (:key x)
                      (om/get-computed x :key)
                      (:react-key x)
                      (om/get-computed x :react-key)
                      (str (:db/id x) (om/get-computed x :attr-key))))}))
