(ns datomscript.client.om.syncing
  (:require [om.next.impl.parser :as om.parser]
            [om.next :as om]
            [om.next.protocols :as om.protocols]
            [datomscript.client.om.subscription]
            [datascript.core :as d]
            [datomscript.client.om.db :as om.db]))

(def vconcat (comp vec concat))

(defn syncing-updates-fn [updates-map]
  (fn [query db]
    (let [query-sub (reduce (fn [acc e]
                              (if-let [n (get-in (om.parser/expr->ast e) [:params :new])]
                                (vconcat acc n)
                                acc))
                            []
                            (filter datomscript.client.om.subscription/match-subscription-update query))
          query (concat query-sub (remove datomscript.client.om.subscription/match-subscription-update query))]      
      (reduce
       (fn [tx-data e]            
         (if-let [tx-fn (get updates-map (:dispatch-key (om.parser/expr->ast e)))]
           (merge-with
            vconcat tx-data (tx-fn e db))
           tx-data))
       {}
       query))))

(defn update-remote-sync!
  [{:keys [conn tx-data subs keys reconciler]}]  
  (let [tx-data (when (seq tx-data)
                  (conj tx-data {:db/id (datomscript.client.om.db/tempid)
                                 :app/id :app/subscriptions
                                 :app/value (or subs {})}))]    
    (when (seq tx-data)
      (d/transact conn tx-data)
      (om.protocols/queue! reconciler (set keys)))))
