(ns datomscript.client.om.router
  (:require [datascript.core :as d]
            [om.next :as om]
            [datomscript.client.om.db :as om.db]))

(defprotocol key-fn
  (keyfn [this]))

(defn map-routing
  [{:keys [router-fns conn component-fns special-routing params transact-fn]}]
  (let [route (:route params)
        route-fn (get router-fns route)
        {:keys [route route-fn]} (special-routing {:route route
                                                   :route-fn route-fn
                                                   :db @conn})
        {:keys [tx-data tx-callback]}
        ,(route-fn {:conn conn
                    :params params})        
        new-query (tx-callback
                    (if (seq tx-data)                      
                      (transact-fn conn tx-data)                     
                      {}))]    
    {:query-params new-query
     :component-type (cond
                       (get (:root component-fns) route) :root
                       (get (:component component-fns) route) :component
                       :else :unknown)}))

(defn route-request [{:keys [router-fns set-query! special-routing component-fns transact-fn]}]
  (fn [{:keys [conn reconciler component] :as env} _ params]
    {:action
     (fn [_]     
       (try
         (let [{:keys [query-params component-type]}
               ,(map-routing
                 {:router-fns router-fns
                  :component-fns component-fns
                  :special-routing special-routing
                  :conn conn
                  :params params
                  :transact-fn transact-fn})               
               component (case component-type
                           :root
                           ,(if (and (om/reconciler? reconciler)
                                     (om/component? (om/app-root reconciler)))
                              (om/app-root reconciler)
                              component)
                           :component component
                           :else nil)]
           (when (nil? component)
             (.error js/console "There was no component specified for the params "
                     (pr-str params)))
           (when (nil? query-params)
             (.error js/console "There was no query-params specified"
               (pr-str params)))           
           (set-query! component (cond-> query-params
                                   (not (:query query-params))
                                   (assoc :query (om/query component)))))
         (catch js/Error e
           (.error js/console e))))}))

(defn factory-mapper [components]
  (reduce-kv
    (fn [acc k view]      
      (assoc acc k (om/factory view (keyfn view)) ))
    {}
    components))

(defn query-mapper [views]
  (reduce-kv
   (fn [acc k v]
     (assoc acc k (om/get-query v)))
   {}
   views))

(defn simple-route [{:keys [route class component]}]
  (fn [{:keys [conn params]}]
    (let [id (om.db/db-id-from-app-id @conn route)]
      {:tx-data [{:db/id id
                  :app/id route}]
       :tx-callback
       (fn [{:keys [db-after tx-data tempids] :as x} ]
         (let [raw-query (om/query class)             
               raw-params (om/params class)
               params raw-params
               query raw-query]
           {:params {:body-component component
                     :body-query (om/bind-query query params)
                     :body-params {:query query
                                   :params params}}}))})))
