(ns datomscript.client.om.db  
  (:require [datascript.core :as d]))

(def schema
  {:app/attr {:db/valueType :db.type/ref
              :db/cardinality :db.cardinality/many}
   :model/type {:db/valueType :db.type/enum}
   :app/attr-key {}
   :app/cache {:db/unique :db.unique/identity}   
   :app/editing {:db/valueType :hash-map}
   :app/global-load? {}
   :app/id {:db/unique :db.unique/identity}        
   :app/ref {:db/valueType :db.type/ref}
   :app/ref-many {:db/valueType :db.type/ref
                  :db/cardinality :db.cardinality/many}   
   :app/syncing? {:db/valueType :boolean}
   :app/syncing-attrs {:db/valueType :vector}
   :app/error {:db/valueType :db.type/ref
               :db/cardinality :db.cardinality/many}
   :app.error/read {}
   :app.error/key {}
   :app.error/message {}
   :app/sub-value {}
   :app/value {}
   
   :db/id {}})

(defn tempid
  ([]
   (d/tempid :db.part/user))
  ([id]
   (d/tempid :db.part/user id)))

(defn db-id-from-app-id [db app-id]
  (or (:db/id (d/entity db [:app/id app-id]))
    (tempid)))

(defn db-id-from-ident [db ident]
  (or (:db/id (d/entity db ident))
    (tempid)))
