(ns datomscript.client.om.attr
  (:require [datascript.core :as d]
            [utils.misc]
            [datomscript.client.datascript :as datom.ds]))

(defn attr-id-by-attr-key [db id attr-key]  
  (d/q '[:find ?attr .
         :in $ ?id ?attr-key
         :where
         [?id :app/attr ?attr]
         [?attr :app/attr-key ?attr-key]]
       db id attr-key))

(defn -app-attr-tx [{:keys [db id attr-key attr-params]}]  
  (let [attr-id (attr-id-by-attr-key db id attr-key)        
        [attr-id new?] (if-not attr-id
                         [(datom.ds/tempid) true]
                         [attr-id false])]    
    (cond-> (merge {:db/id attr-id}
                   attr-params)
      new? (assoc :app/attr-key attr-key
                  :app/_attr id))))

(defn app-attr-tx [db [id attr-map]]  
  (reduce-kv
   (fn [tx attr-key attr-params]     
     (conj tx (-app-attr-tx
               {:db db
                :id id
                :attr-key attr-key
                :attr-params attr-params})))
   []
   attr-map))

(defn read-attr [{:keys [conn parser entity query] :as env} _ _]  
  {:value (parser env query)})

(defn read-attr-key [{:keys [conn ast parser entity query]} key _]  
  (let [attr-key (second (:key ast))
        id (:db/id entity)
        attr-id (attr-id-by-attr-key @conn id attr-key)
        pull-map (when attr-id
                   (d/pull @conn query attr-id))]
    {:value pull-map }))




