(ns datomscript.client.mui
  (:require [camel-snake-kebab.core :as k])
  #?(:cljs (:require-macros [datomscript.client.mui :refer [define-widgets]]))
  (:refer-clojure :exclude [list]))

(def original-symbols
  ['Badge 'Button 'Card 'CardActions 'CardMedia 'CardMenu 'CardText 'CardTitle 'Cell 'Checkbox 'Content 'DataTable 'Dialog 'DialogActions 'DialogTitle 'Drawer 'FABButton 'Footer 'FooterLinkList 'FooterSection 'Grid 'Header 'HeaderRow 'HeaderTabs 'Icon 'IconButton 'IconToggle 'Index 'Layout 'LinkList 'List 'ListItem 'ListItemAction 'ListItemContent 'Menu 'Navigation 'ProgressBar 'Radio 'RadioGroup 'Section 'Slider 'Snackbar 'Spacer 'Spinner 'Switch 'Tab 'TabBar 'Tabs 'Textfield 'Tooltip])

(def widget-symbols
  (map k/->kebab-case-symbol original-symbols))

(defn define-widget-fn [name other-name]
  (clojure.core/list 'defn name ['opts '& 'children]
                     (clojure.core/list 'js/React.createElement (symbol (str 'js/ReactMDL. other-name)) 'opts 'children)))

(defmacro define-widgets []
  `(do ~@(map define-widget-fn widget-symbols original-symbols)))

#?(:cljs
   (define-widgets))
