(ns datomscript.api-dev.server.test
  (:require [clojure.core.async :as async]))

(defn auth-header [token]
  {"Authorization" (format "Bearer %s" token)})

(defn timeout-query [c & [time]]
  (let [time-ch (async/timeout (or time 500))]
    (let [[v p] (async/alts!! [c time-ch] )]
      (if (= p time-ch)
        :timeout
        v))))

(defn basic-test-db-config []
  {:dbs {:main (format "datomic:mem://test-%s" (java.util.UUID/randomUUID))}})
