(ns confil.literals
  (:refer-clojure :exclude [bytes])
  (:require [clojure.string :as cstr]
            [clj-time.core :as clj-time]
            [clj-time.format :as time-format]))

(defn- long-or-double [number]
  (if (zero? (BigDecimal. (mod number 1)))
    (.longValue number)
    (.doubleValue number)))

(defn- handle-string-num
  ([num-or-string num-fn]
   (handle-string-num num-or-string num-fn #(Double/valueOf %)))
  ([num-or-string num-fn string-fn]
   (cond
     (string? num-or-string) (num-fn (-> (cstr/trim num-or-string)
                                         string-fn
                                         long-or-double))
     (number? num-or-string) (num-fn (long-or-double num-or-string)))))

(defn nseconds
  ""
  [x]
  )

(defn mseconds
  ""
  [x])

(defn seconds
  ""
  [x])

(defn minutes
  ""
  [x])

(defn hours
  ""
  [x])

(defn days
  ""
  [x])

(def multi-parser
  (time-format/formatter clj-time/utc "YYYY-MM-dd" "YYYY/MM/dd" "MM/dd/YYY" "mm-dd-YYYY"))

(defn date
  ""
  [x])

(defn bytes
  ""
  [x])

(defn kbytes
  ""
  [x])

(defn mbytes
  ""
  [x])

(defn gbytes
  ""
  [x])

