(ns ui-components.layouts.overlays
  (:require [ui-components.forms.course :refer [CourseForm]]
            [ui-components.forms.new-user :refer [NewUserForm]]
            [shared.protocols.loggable :as log]))

(defn overlays [{:keys [user course handlers]}]
  {:new-user  [NewUserForm {:user      user
                            :status    (:status user)
                            :on-cancel (:sign-out handlers)
                            :on-change (:check-user handlers)
                            :on-submit (:sign-up handlers)}]
   :edit-mode [CourseForm {:course    course
                           :status    (:status course)
                           :on-cancel (:switch-to-view-mode handlers)
                           :on-change (:check-course handlers)
                           :on-submit (:save-course handlers)}]})
