(ns ui-components.social-menu
  (:require [ui-components.copy-clipboard :refer [CopyClipboard]]
            [ui-components.semantic :refer [Buttons Button Popup Icon Menu Item MenuItem]]
            [reagent.core :as r]))

(defn tweet [text url]
  (.open js/window (str "http://twitter.com/share?url=" url "&text=" text) "tshare" "height=260,width=550,resizable=0,toolbar=0,menubar=0,status=0,location=0"))


(defn fb [text url]
  (.open js/window (str "http://facebook.com/sharer.php?u=" url) "fbshare" "height=380,width=660,resizable=0,toolbar=0,menubar=0,status=0,location=0"))

(def handlers
  {:twitter tweet
   :facebook fb})

(defn SocialProvider [provider url]
  (let [handler (provider handlers)]
    [Button {:size :big
             :onClick #(handler "Cool!" url)
             :disabled (not handler)}
     [Icon {:name provider}]]))

(defn SocialMenu [{:keys [providers url]}]
  [:div
   [Buttons {:compact false
             :size :small
             :basic true
             :fluid true}
    (map (fn [provider] ^{:key provider} [SocialProvider provider url]) providers)
    [Button #_{:position :right}
     [Popup  {:trigger (r/as-element [:div [CopyClipboard url]])
              :position "bottom right"
              :inverted true
              :wide :very
              :content (r/as-element [:div url])}]]]])



