(ns ui-components.layouts.new-course
  (:require [ui-components.forms.new-course :refer [NewCourseForm]]
            [ui-components.layouts.base :refer [BaseLayout]]
            [ui-components.semantic :refer [Modal]]))

(defn NewCourseLayout [{:keys [new-course respond handlers] :as view-data}]
  [BaseLayout
   view-data
   (when new-course
     [Modal {:open true} [NewCourseForm {:course new-course
                                         :status    (:status new-course)
                                         :on-cancel (:go-home handlers)
                                         :on-change (:check-course handlers)
                                         :on-submit (:save-course handlers)}]])])
