(ns ui-components.layouts.checkpoint
  (:require [ui-components.semantic :refer [Segment Button Grid GridColumn GridRow]]
            [ui-components.course-card :refer [CourseCard]]
            [ui-components.dashboard :refer [Dashboard]]
            [ui-components.layouts.base :refer [BaseLayout]]
            [ui-components.viewer :refer [Viewer]]
            [shared.protocols.loggable :as log]))

(defn CheckpointLayout [{:keys [user course resource checkpoint respond handlers] :as view-data}]
  (let [edit-course (case (:status user)
                      :signed-in  (partial (:edit-course handlers) course)
                      :signed-out (:sign-in handlers)
                      identity)
        toggle-status       (case (:status user)
                              :signed-in  (partial (:toggle-status handlers) course)
                              :signed-out (:sign-in handlers)
                              identity)]
    [BaseLayout
     view-data
     [Grid {:padded true}
      [GridRow {:only :mobile}
       [GridColumn
        [Viewer {:resource   resource
                 :checkpoint checkpoint}]]]

      [GridRow {:only :tablet}
       [GridColumn
        [Dashboard
         [CourseCard {:course        course
                      :trackable?    true
                      :toggle-status toggle-status}]
         [Button {:onClick edit-course
                  :secondary true
                  :fluid   true} "Edit"]]
        [Viewer {:resource   resource
                 :checkpoint checkpoint}]]]

      [GridRow {:only :computer}
       [GridColumn
        [Dashboard
         [CourseCard {:course        course
                      :trackable?    true
                      :toggle-status toggle-status}]
         [Segment {:basic true}
          [Button {:onClick edit-course
                   :secondary true
                   :fluid   true} "Edit"]]]
        [Viewer {:resource   resource
                 :checkpoint checkpoint}]]]]]))
