(ns ui-components.labels
  (:require [clojure.string :as c-str]
            [cuerdas.core :as str]
            [ui-components.semantic :refer [Label LabelGroup]]))

(defn format-label [label]
  (let [label-words (c-str/split label "-")
        capitalized (map #(str/capitalize %) label-words)]
    (c-str/join "-" capitalized)))

(defn Labels [items]
  [LabelGroup
   (map (fn [tag] [Label {:key tag
                          :size "mini"} (format-label tag)]) items)])
