(ns ui-components.course-meta
  (:require [ui-components.semantic
             :refer
             [Item ItemContent Image ItemHeader Image ItemMeta]]
            [cuerdas.core :as str]))

(defn CourseMeta [{:keys [curator] :as course}]
  [Item
   [Image {:floated "left"
           :shape :circular
           :size :mini
           :src (:portrait-url (meta course))}]
   [ItemContent
    [ItemMeta "Curated By"]
    (str/capitalize curator)]])
