(ns ui-components.actions-panel
  (:require [cuerdas.core :as str]
            [ui-components.semantic
             :refer
             [Button Icon Item JSItem Loader MenuMenu]]
            [reagent.core :as r]))

(defn LoggedInMenu [user-name sign-out]
  [MenuMenu {:position :right}
   [Item
    [:a {:href "/courses/new"} "Create Course"]]
   [Item (str/capitalize user-name)]
   [Item
    [Button {:on-click sign-out} "Sign Out"]]])

(defn LoadingMenu [local-state]
  [MenuMenu {:position :right}
   [Item [Loader {:active true
                  :size :small
                  :inline true}]]])

(defn GuestMenu [sign-in]
  [MenuMenu {:position :right}
   [Item
    [Button {:basic true
             :on-click sign-in} "Sign In"]]])

(def local-state (r/atom {:is-signing-in? false}))

(defn ActionsPanel [{:keys [user-status user-name sign-in sign-out]}]
  (case user-status
    :signing-in [LoadingMenu]
    :signed-in  [LoggedInMenu user-name sign-out]
    [GuestMenu sign-in]))
