(ns ui-components.forms.sign-up
  (:require [ui-components.semantic :refer [Button Message Header Segment Form FormField FormInput]]
            [ui-components.forms.sections.controls :refer [FormControls]]
            [ui-components.forms.utils :refer [debounce submit-form]]
            [ui-components.overlay :refer [Overlay]]
            [shared.protocols.specced :as sp]
            [reagent.core :as r]
            [shared.protocols.loggable :as log]))

(defn update-user-name [profile-atom user-name]
  (swap! profile-atom (fn [profile] (assoc profile :user-name user-name))))

(defn SignUpForm [{:keys [draft on-submit on-change on-cancel]}]
  (let [profile (r/atom draft)]
    (fn [{:keys [flags errors]}]
      [Overlay {:title "Sign Up"}
       [Form {:error nil #_(= status :rejected)
              :onBlur #(on-change @profile)
              :onSubmit identity #_(submit-form %1 user on-submit)}
        [Message {:error true} "This username already exists..."]
        [FormField
         [:label "User Name"]
         [FormInput {:placeholder "please enter your name..."
                     :autoFocus true
                     :value (or (:user-name @profile) "")
                     :error nil #_(contains? invalid-fields :user-name)
                     :onChange #(update-user-name profile (.-value %2))}]]]
       [FormControls {:on-cancel on-cancel
                      :on-confirm identity #_(on-submit user)
                      :loading?  false #_(= status :checking)
                      :disabled? false #_(not saveable?)}]])))
