(ns ui-components.menubar
  (:require [ui-components.actions-panel :refer [ActionsPanel]]
            [ui-components.semantic :refer [Button JSItem Icon Item ItemHeader Menu]]))

(defn Menubar [{:keys [sign-in flags sign-up sign-out user logo]}]
  (let [{:keys [status user-name]} user]
    [Menu
     logo
     [ActionsPanel {:user-name user-name
                    :user-status  status
                    :flags flags
                    :sign-up sign-up
                    :sign-in sign-in
                    :sign-out sign-out}]]))
