(ns ui-components.layouts.sign-up
  (:require [ui-components.layouts.base :refer [BaseLayout]]
            [ui-components.forms.sign-up :refer [SignUpForm]]
            [shared.protocols.loggable :as log]
            [ui-components.semantic :refer [Modal]]))

(defn SignUpLayout [{:keys [profile-draft flags handlers] :as view-data}]
  [BaseLayout view-data
   (when (:authenticated? flags)
     [SignUpForm {:draft     profile-draft
                   :on-cancel (:go-home handlers)
                   :on-change (:update-draft handlers)
                   :on-submit identity}])])
