(ns ui-components.layouts.new-course
  (:require [ui-components.forms.course :refer [CourseForm]]
            [ui-components.layouts.base :refer [BaseLayout]]
            [shared.protocols.loggable :as log]
            [ui-components.semantic :refer [Modal]]))

(defn NewCourseLayout [{:keys [flags invalid-fields course-draft respond handlers] :as view-data}]
  [BaseLayout view-data
   (when-not (:signed-in? flags)
     [CourseForm {:draft       course-draft
                  :flags       flags
                  :errors      (:errors course-draft)
                  :checkpoints (:checkpoints course-draft)
                  :on-cancel   (:go-home handlers)
                  :on-change   (:update-draft handlers)
                  :on-submit   (:save-draft handlers)}])])
