(ns ui-components.forms.sign-up
  (:require [ui-components.semantic :refer [Button Message Header Segment Form FormField FormInput]]
            [ui-components.forms.sections.controls :refer [FormControls]]
            [ui-components.forms.utils :refer [debounce submit-form]]
            [ui-components.overlay :refer [Overlay]]
            [shared.protocols.specced :as sp]
            [reagent.core :as r]
            [shared.protocols.loggable :as log]))

(defn update-user-name [user-atom user-name]
  (swap! user-atom (fn [user] (assoc user :user-name user-name))))

(defn SignUpForm [{:keys [draft on-submit on-change on-cancel]}]
  (let [user (r/atom draft)]
    (fn [{:keys [flags errors]}]
      [Overlay {:title "Sign Up"}
       [Form {:error nil #_(= status :rejected)
              :onBlur #(on-change @user)
              :onSubmit identity #_(submit-form %1 user on-submit)}
        [Message {:error true} "This username already exists..."]
        [FormField
         [:label "User Name"]
         [FormInput {:placeholder "please enter your name..."
                     :autoFocus true
                     :value (or (:user-name @user) "")
                     :error nil #_(contains? invalid-fields :user-name)
                     :onChange #(update-user-name user (.-value %2))}]]]
       [FormControls {:on-cancel on-cancel
                      :on-confirm identity #_(on-submit user)
                      :loading?  false #_(= status :checking)
                      :disabled? false #_(not saveable?)}]])))
