(ns ui-components.forms.new-user
  (:require [ui-components.semantic :refer [Button Message Header Segment Form FormField FormInput]]
            [ui-components.forms.sections.controls :refer [FormControls]]
            [ui-components.forms.utils :refer [debounce submit-form]]
            [ui-components.overlay :refer [Overlay]]
            [shared.protocols.specced :as sp]
            [reagent.core :as r]
            [shared.protocols.loggable :as log]))


(defn NewUserForm [{:keys [draft on-submit on-change on-cancel]}]
  [Overlay {:title "Sign Up"}
   [Form {:error nil #_(= status :rejected)
          :onSubmit identity #_(submit-form %1 user on-submit)}
    [Message {:error true} "This username already exists..."]
    [FormField
     [:label "User Name"]
     [FormInput {:placeholder "please enter your name..."
                 :autoFocus true
                 :value (or (:user-name draft) "")
                 :error nil #_(contains? invalid-fields :user-name)
                 :onChange #(on-change (.-value %2))}]]]
   [FormControls {:on-cancel on-cancel
                  :on-confirm identity #_(on-submit user)
                  :loading?  false #_(= status :checking)
                  :disabled? false #_(not saveable?)}]])
