(ns ui-components.layouts.overlays
  (:require [ui-components.forms.course :refer [CourseForm]]
            [ui-components.forms.new-user :refer [NewUserForm]]
            [ui-components.confirm :refer [Confirm]]
            [shared.protocols.loggable :as log]))

(defn overlays [{:keys [user course course-draft flags handlers]}]
  (let [{:keys [switch-to check-user sign-up check-course
                fork-course go-to-fork save-course]} handlers]
    {:new-user       [NewUserForm {:user      user
                                   :status    (:status user)
                                   :on-cancel #(switch-to :view-mode)
                                   :on-change check-user
                                   :on-submit sign-up}]
     :fork-modal     [Confirm     {:course     course
                                   :title      "Want to Fork?"
                                   :content    "Lorem Ipsum Tralalala"
                                   :confirm-message "Fork"
                                   :on-cancel #(switch-to :view-mode)
                                   :on-confirm fork-course}]
     :redirect-modal [Confirm     {:course     course
                                   :title      "Want to Redirect?"
                                   :content    "Lorem Ipsum Tralalala"
                                   :confirm-message "Redirect"
                                   :on-cancel #(switch-to :view-mode)
                                   :on-confirm (partial go-to-fork course)}]
     :edit-mode      [CourseForm  {:draft     course-draft
                                   :flags     flags
                                   :errors    (:errors course-draft)
                                   :on-cancel #((:switch-to handlers):view-mode)
                                   :on-change (:update-draft handlers)
                                   :on-submit (:save-draft handlers)}]}))
