(ns ui-components.forms.sections.goal
  (:require [ui-components.semantic :refer [FormField FormInput]]
            [ui-components.forms.sections.message :refer [Message]]
            [shared.protocols.loggable :as log]))

(defn GoalSection [{:keys [goal errors invalid? errors update]}]
  [FormField {:error       (boolean errors)}
   [:label "Goal of the Course"]
   [FormInput {:placeholder "Goal"
               :autoFocus   true
               :value       (or goal "")
               :onChange    #(update (.-value %2))}]
   [:div
    (keep (fn [error]
            ^{:key error} [Message error]) errors)]])
