(ns ui-components.forms.sections.goal
  (:require [ui-components.semantic :refer [FormField Message FormInput]]
            [shared.protocols.loggable :as log]))

(def notifications
  {:existing   {:type :error
                   :message "You already have a course with this title!"}
   :spec-error {:type :error
                :message "A goal should consist of at least 4 characters"}})

(defn GoalSection [{:keys [goal errors invalid? errors update]}]
  [FormField
   [:label "Goal of the Course"]
   [FormInput {:placeholder "Goal"
               :autoFocus   true
               :value       (or goal "")
               :error       (boolean errors)
               :onChange    #(update (.-value %2))}]
   [:div (keep (fn [reason]
                 ^{:key reason} [Message {(-> notifications reason :type) true} (-> notifications reason :message)]) errors)]])
