(ns ui-components.forms.sections.checkpoints
  (:require [ui-components.forms.sections.checkpoint :refer [CheckpointSection]]
            [ui-components.forms.utils :refer [prevent-default debounce submit-form]]
            [ui-components.semantic :refer [Message Button Divider Icon]]
            [shared.protocols.loggable :as log]))

(def notifications
  {:spec-error {:type :error
                :message "A course should have at least 2 checkpoints"}})

(defn CheckpointsSection [{:keys [checkpoints errors remove-checkpoint update-checkpoint]}]
  [:div
   [Divider {:horizontal true} "Checkpoints"]
   (keep (fn [reason]
           ^{:key reason} [Message {(-> notifications reason :type) true} (-> notifications reason :message)]) errors)
   (map-indexed (fn [index checkpoint]
                  ^{:key index} [CheckpointSection
                                 {:on-change update-checkpoint
                                  :on-remove remove-checkpoint} (assoc checkpoint :index index)])
                checkpoints)])
