(ns ui-components.forms.sections.checkpoint
  (:require [ui-components.semantic :refer [Button Icon FormField FormGroup FormInput]]
            [shared.protocols.specced :as sp]
            [shared.protocols.loggable :as log]))

(defn CheckpointSection [{:keys [on-change on-remove]} {:keys [task resource-url] :as checkpoint}]
  (let [valid? (sp/valid? checkpoint)
        errors (sp/errors checkpoint)
        invalid-fields (into #{} (mapcat :in (-> errors first second)))]
  [FormGroup
   [FormField {:width 6}
    [:label "Task"]
    [FormInput {:placeholder "Task"
                :value (or task "")
                :error (contains? invalid-fields :task)
                :onChange #(on-change (assoc checkpoint :task (.-value %2)))}]]
   [FormField {:width 9}
    [:label "Resource Url"]
    [FormInput {:placeholder "Url"
                :value (or resource-url "")
                :error (contains? invalid-fields :resource-url)
                :onChange #(on-change (assoc checkpoint :resource-url (.-value %2)))}]]
    [FormField {:width 1}
     [:label {:className "invisible"} "."]
     [Button {:fluid true
              :icon "remove"
              :onClick #(on-remove checkpoint)}]]]))
