(ns ui-components.forms.new-course
  (:require [reagent.core :as r]
            [shared.protocols.actionable :as ac]
            [ui-components.forms.sections.checkpoints :refer [CheckpointsSection]]
            [ui-components.forms.sections.controls :refer [FormControls]]
            [ui-components.forms.sections.goal :refer [GoalSection]]
            [ui-components.forms.utils :refer [debounce prevent-default]]
            [ui-components.overlay :refer [Overlay]]
            [ui-components.semantic :refer [Form]]))

(defn create-checkpoint [local-state]
  (swap! local-state #(ac/perform %1 [:add :new-checkpoint])))

(defn remove-checkpoint [local-state checkpoint]
  (swap! local-state #(ac/perform %1 [:remove checkpoint])))

(defn update-checkpoint [local-state checkpoint]
  (swap! local-state #(ac/perform %1 [:update checkpoint])))

(defn update-goal [local-state new-goal]
  (swap! local-state assoc :goal new-goal))

(defn NewCourseForm [{:keys [draft on-cancel on-change on-submit]}]
  (let [local-state       (r/atom draft)
        update-goal       (comp (debounce on-change 500) update-goal)
        create-checkpoint (comp (debounce on-change 500) create-checkpoint)
        update-checkpoint (comp (debounce on-change 500) update-checkpoint)
        remove-checkpoint (comp (debounce on-change 500) remove-checkpoint)]
    (fn [{:keys [flags draft]}]
      (let [{:keys [saveable? checking?]}  flags
            {:keys [errors]}               draft]
        [Overlay {:title "Create Course"
                  :size  :large}
         [Form {:error    (not (empty? errors))
                :onSubmit #(prevent-default % identity)}
          [GoalSection {:goal     (:goal @local-state)
                        :errors   (:goal errors)
                        :update   (partial update-goal local-state)}]
          [CheckpointsSection {:update-checkpoint (partial update-checkpoint local-state)
                               :errors   (:checkpoints errors)
                               :remove-checkpoint (partial remove-checkpoint local-state)
                               :checkpoints       (:checkpoints @local-state)}]]
         [FormControls {:on-cancel  on-cancel
                        :on-confirm #(on-submit @local-state)
                        :create-checkpoint #(create-checkpoint local-state)
                        :loading?   checking?
                        :disabled?  (not saveable?)}]]))))
