(ns ui-components.forms.sections.goal
  (:require [ui-components.semantic :refer [FormField FormInput]]
            [shared.protocols.loggable :as log]))

(defn GoalSection [{:keys [goal invalid? errors check update]}]
  [FormField
   [:label "Goal of the Course"]
   [FormInput {:placeholder "Goal"
               :autoFocus   true
               :value       (or goal "")
               :error       (boolean errors)
               :onBlur      check
               :onChange    #(update (.-value %2))}]])
