(ns ui-components.layouts.main
  (:require [ui-components.flash :refer [Flash]]
            [ui-components.semantic :refer [Grid GridRow GridColumn Button Icon JSItem]]
            [shared.protocols.loggable :as log]))

(def notifications
  {:existing-goal {:type :error
                   :message "You already have a course with this title!"}
   :not-logged-in {:type :warning
                   :message "You are not logged in yet..."}})

(defn Main [{:keys [notification]} content]
  [:div
   (when notification [Flash (notification notifications)])
  content])
