(ns ui-components.layouts.new-course
  (:require [ui-components.forms.new-course :refer [NewCourseForm]]
            [ui-components.layouts.base :refer [BaseLayout]]
            [shared.protocols.loggable :as log]
            [ui-components.semantic :refer [Modal]]))

(defn NewCourseLayout [{:keys [flags busy? errors draft respond handlers] :as view-data}]
  [BaseLayout
   view-data
   (when (:editable? flags)
     [NewCourseForm {:course      draft
                     :flags       flags
                     :errors      errors
                     :on-cancel   (:go-home handlers)
                     :on-change   (:check-course handlers)
                     :on-submit   (:save-course handlers)}])])
