(ns ui-components.forms.sections.checkpoints
  (:require [ui-components.forms.sections.checkpoint :refer [CheckpointSection]]
            [ui-components.semantic :refer [Button Divider Icon]]
            [shared.protocols.loggable :as log]))

(defn on-click [event handler]
  (.preventDefault event)
  (handler))

(defn CheckpointsSection [{:keys [checkpoints create-checkpoint update-checkpoint]}]
  [:div
   #_[Divider {:horizontal true} "Checkpoints"]
   (map (fn [{:keys [checkpoint-id] :as checkpoint}]
          ^{:key checkpoint-id} [CheckpointSection {:on-change update-checkpoint} checkpoint])
        checkpoints)
   [Button {:floated :right
            :onClick #(on-click % create-checkpoint)
            :compact true}
    [Icon {:name "plus"}]]])
