(ns ui-components.forms.sections.controls
  (:require [ui-components.semantic :refer [Button]]))

(defn cancel-form [event handler]
  (.preventDefault event)
  (handler))

(defn FormControls [{:keys [on-cancel loading? disabled?]}]
  [:div
   [Button {:color :red
            :onClick #(cancel-form % on-cancel)} "Cancel"]
   [Button {:primary true
            :loading loading?
            :disabled disabled?
            :type :submit} "Save"]])
