(ns ui-components.forms.course
  (:require [reagent.core :as r]
            [shared.protocols.actionable :as ac]
            [shared.protocols.specced :as sp]
            [ui-components.forms.sections.checkpoints :refer [CheckpointsSection]]
            [ui-components.forms.sections.controls :refer [FormControls]]
            [ui-components.semantic :refer [Form Header Segment]]
            [shared.protocols.loggable :as log]))

(defn create-checkpoint [local-state]
  (swap! local-state #(ac/perform %1 [:add :new-checkpoint])))

(defn update-checkpoint [local-state checkpoint]
  (swap! local-state #(ac/perform %1 [:update checkpoint])))

(defn submit-form [event course handler]
  (.preventDefault event)
  (handler course))

(defn CourseForm [{:keys [course on-cancel on-submit]}]
  (let [local-state (r/atom course)]
    (fn []
      (let [{:keys [goal checkpoints] :as course} @local-state
            valid?            (sp/valid? course)
            errors            (sp/errors course)
            invalid-fields    (into #{} (mapcat :in (-> errors first second)))]
        [Segment {:basic true}
         [Header goal]
         [Form {:onSubmit #(submit-form %1 course on-submit)}
          [CheckpointsSection {:create-checkpoint #(create-checkpoint local-state)
                               :update-checkpoint (partial update-checkpoint local-state)
                               :checkpoints checkpoints}]
          [FormControls {:on-cancel on-cancel
                         :disabled? (not valid?)}]]]))))
