(ns shared.models.status.index
  (:require [shared.models.checkpoint.index :as checkpoint]
            [shared.protocols.convertible :refer [Convertible]]
            [shared.protocols.actionable :as ac :refer [Actionable]]
            [shared.protocols.specced :refer [Specced]]
            [shared.models.query.index :as query]
            [shared.protocols.loggable :as log]))

(defn to-query [{:keys [course-id learner]}]
  (query/create {:learner     learner
                 :course-id   course-id}))

(defrecord Status []
  Actionable
  (-perform [this [_ query]]
    #_(log/log this)
    #_(log/log query)
    (assoc this :cached true))
  Convertible
  (-to-query [this] (to-query this))
  Specced
  (-resolve [this] :statuses))


(defn initialize [learner course-id checkpoint-id]
  (-> {:learner learner
       :course-id course-id
       :checkpoints [{:checkpoint-id checkpoint-id
                      :completed? (.now js/Date)}]}
      map->Status
      (with-meta {:spec :offcourse/status})))

(defn create [status]
  (-> status
      map->Status
      (with-meta {:spec :offcourse/status})))
