(ns shared.specs.raw
  (:require [cljs.spec :as spec]
            [shared.specs.resource]
            [shared.specs.checkpoint]
            [shared.specs.course]
            [shared.protocols.loggable :as log]))

(spec/def :raw/new-checkpoint  (spec/keys :req-un [:checkpoint/task
                                                   :checkpoint/checkpoint-id
                                                   :resource/resource-url]))

(spec/def ::checkpoints (spec/coll-of :raw/new-checkpoint :min-count 3))
(spec/def :raw/new-course (spec/keys :req-un [:course/curator
                                              :course/goal
                                              ::checkpoints]))
