(ns shared.models.checkpoint.index
  (:require [shared.specs.checkpoint :as specs]
            [shared.protocols.queryable :refer [Queryable]]))

(defrecord Checkpoint [])

(defn create [raw-checkpoint]
  "creates a checkpoint"
  (-> raw-checkpoint
      map->Checkpoint
      (with-meta {:spec :offcourse/new-checkpoint})))

(defn new [checkpoint-id]
  "creates a checkpoint"
  (-> {:checkpoint-id checkpoint-id
       :task nil
       :resource-url nil}
      map->Checkpoint
      (with-meta {:spec :offcourse/new-checkpoint})))
