(defproject offcourse/shared "0.11.9-SNAPSHOT"
  :description     "This is an echo lambda function. It's mainly used for debugging purposes."
  :url             "http://example.com/FIXME"
  :license         {:name "Eclipse Public License"
                    :url "http://www.eclipse.org/legal/epl-v10.html"}
  :plugins         [[lein-cljsbuild "1.1.7"]]
  :dependencies    [[org.clojure/clojure         "1.9.0-alpha17"]
                    [funcool/cuerdas             "2.0.3"]
                    [com.rpl/specter             "1.0.3"]
                    [org.clojure/core.async      "0.3.443"]
                    [offcourse/specs             "0.1.1"]
                    [org.clojure/clojurescript   "1.9.854"]]
  :repositories [["snapshots" {:url "https://clojars.org/repo"
                               :username :env/clojars_username
                               :password :env/clojars_password}]
                 ["releases" {:url "https://clojars.org/repo"
                              :sign-releases false
                              :username :env/clojars_username
                              :password :env/clojars_password}]]
  :profiles {:dev {:dependencies [[com.cemerick/piggieback "0.2.2"]
                                  [org.clojure/tools.nrepl "0.2.10"]]
                   :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}}
  :cljsbuild       {:builds [{:id "prod"
                              :source-paths ["src"]
                              :compiler {:target :nodejs
                                         :optimizations :simple
                                         :pretty-print true
                                         :parallel-build true}}]})

