(ns shared.protocols.actionable
  (:require [shared.models.action.index :as action]))

(defprotocol Actionable
  "The Actionable protocol allows offcourse components, models, and adapters to
  handle and respond to offcourse events"
  (-request [this action])
  (-check [this action] [this action data])
  (-perform [this action] [this resource-name action]))

(defn request
  "turns an action into a request event"
  ([this action] (-request this (action/create action))))

(defn perform
  "exectutes an action with (possible) side-effects"
  ([{:keys [action-spec] :as this} action]
   (if action-spec
     (-perform this (action/create (with-meta action (merge (meta action) {:spec action-spec}))))
     (-perform this (action/create action)))))

(defn check
  "checks if an action if valid"
  ([this action] (-check this (action/create action)))
  ([this action data] (-check this (action/create action) data)))
