(ns shared.models.event.index
  (:require [shared.protocols.convertible :as cv :refer [Convertible]]
            [shared.protocols.specced :as sp :refer [Specced]]
            [shared.protocols.loggable :as log]
            [shared.protocols.specced :as sp]
            [cljs.spec.alpha :as spec]))

(defn override [event]
  (specify event
    Specced
    (-resolve [this]
      (let [resolved-event (spec/conform (:spec (meta this)) this)]
        (if (= (clj->js resolved-event) "invalid")
          :invalid-event
          [(first resolved-event) (-> resolved-event second first)])))))

(defn create [event]
  (-> event
      (with-meta {:spec :offcourse/event})
      override))
