(ns shared.models.query.index
  (:require [shared.protocols.specced :refer [Specced]]
            [cljs.spec.alpha :as spec]
            [shared.protocols.loggable :as log]))

(defn- override [query]
  (specify query
    Specced
    (-resolve [this]
      (let [resolved-query (spec/conform (:spec (meta this)) this)]
        (if (= (clj->js resolved-query) "invalid")
          :invalid-query
          (first resolved-query))))))

(defn create
  "creates a new query"
  [query]
  (-> query
      (with-meta (merge (meta query) {:spec :offcourse/query}))
      override))
