(ns shared.models.action.index
  (:require [shared.protocols.specced :refer [Specced]]
            [cljs.spec.alpha :as spec]
            [shared.protocols.loggable :as log]
            [shared.protocols.specced :as sp]))

(defn- override [action]
  (specify action
    Specced
    (-resolve [this]
      (let [action (spec/conform (:spec (meta this)) this)]
        (if (= (clj->js action) "invalid")
          [:ignore this]
          [(first action) (-> action second first)])))))

(defn create
  "creates a new action"
  [action]
  (-> action
      (with-meta (merge (meta action) {:spec :offcourse/action}))
      override))
