(ns shared.models.status.actionable
  (:require [com.rpl.specter :refer [ALL]]
            [shared.protocols.queryable :as qa]
            [shared.paths.index :as paths]
            [shared.protocols.loggable :as log])
  (:require-macros [com.rpl.specter.macros :refer [setval transform]]))

(defn perform [this [_ {:keys [checkpoint-id] :as query}]]
  (if (qa/get this query)
    (->> this
         (setval [:checkpoints (paths/checkpoint query)] nil)
         (transform [:checkpoints] #(filter identity %)))
    (transform [:checkpoints] #(conj % {:checkpoint-id checkpoint-id
                                        :completed? (.now js/Date)}) this)))
