(ns shared.models.course.index
  (:require [shared.models.checkpoint.index :as checkpoint]
            [shared.models.course.actionable :as ac-impl]
            [shared.models.course.convertible :as cv-impl]
            [shared.models.course.get :as get-impl]
            [shared.models.course.missing-data :as md-impl]
            [shared.protocols.actionable :as ac :refer [Actionable]]
            [shared.protocols.convertible :refer [Convertible]]
            [shared.protocols.queryable :refer [Queryable]]
            [shared.protocols.specced :refer [Specced]]
            [shared.protocols.loggable :as log]
            [clojure.set :as set]))

(defrecord Course []
  Queryable
  (-get [this query] (get-impl/get this query))
  (-missing-data [this query] (md-impl/missing-data this query))
  Actionable
  (-perform [this action] (ac-impl/perform this action))
  Convertible
  (-to-bookmarks [this] (cv-impl/to-bookmarks this))
  (-to-query [this] (cv-impl/to-query this))
  Specced
  (-resolve [this] :courses))

(defn initialize [{:keys [checkpoints] :as course}]
  (let [id (str (random-uuid))]
    (-> course
         (merge {:base-id id
                 :course-id id
                 :parent-id nil
                 :timestamp (.now js/Date)
                 :version [0 0 1]
                 :revision 0
                 :repository "offcourse"
                 :checkpoints (map checkpoint/create checkpoints)})
         map->Course
         (with-meta {:spec :offcourse/course}))))

(defn create [course]
  (-> course
      (update :checkpoints #(map checkpoint/create %1))
      map->Course
      (with-meta {:spec :offcourse/course})))
