(ns shared.models.status.index
  (:require [shared.models.status.actionable :as ac-impl]
            [shared.models.status.convertible :as cv-impl]
            [shared.models.status.queryable :as qa-impl]
            [shared.protocols.actionable :as ac :refer [Actionable]]
            [shared.protocols.convertible :refer [Convertible]]
            [shared.protocols.queryable :as qa :refer [Queryable]]
            [shared.protocols.specced :refer [Specced]]
            [shared.protocols.loggable :as log]))

(defrecord Status []
  Queryable
  (-get [this query] (qa-impl/get this query))
  Actionable
  (-perform [this action] (ac-impl/perform this action))
  Convertible
  (-to-query [this] (cv-impl/to-query this))
  Specced
  (-resolve [this] :statuses))

(defn initialize [{:keys [base-id learner course-id] :as status-query}]
  (-> {:base-id base-id
       :course-ids #{course-id}
       :learner learner
       :resources #{}}
      map->Status
      (with-meta {:spec :offcourse/status})))

(defn create [status]
  (-> status
      (update-in [:resources] #(into #{} %1))
      (update-in [:course-ids] #(into #{} %1))
      map->Status
      (with-meta {:spec :offcourse/status})))
