(ns shared.models.checkpoint.index
  (:require [offcourse.specs.checkpoint :as specs]
            [shared.protocols.queryable :refer [Queryable]]
            [shared.protocols.specced :refer [Specced]]
            [shared.protocols.loggable :as log]
            [cuerdas.core :as str]))

(defrecord Checkpoint []
  Specced
  (-resolve [this] :checkpoint))

(defn initialize [{:keys [task resource-url]}]
  "initializes a checkpoint"
  (map->Checkpoint {:checkpoint-id (str (random-uuid))
                    :task (str/human task)
                    :resource-url resource-url}))


(defmulti create #(if (:checkpointId %1) :graphql :offcourse))

(defmethod create :graphql [{:keys [checkpointId task tags resourceUrl] :as raw-checkpoint}]
  "creates a checkpoint"
  (-> {:checkpoint-id checkpointId
       :task (str/human task)
       :tags tags
       :resource-url resourceUrl}
      map->Checkpoint
      (with-meta {:spec :checkpoint/valid})))

(defmethod create :offcourse [{:keys [checkpoint-id task tags resource-url] :as raw-checkpoint}]
  "creates a checkpoint"
  (-> {:checkpoint-id checkpoint-id
       :task (str/human task)
       :tags tags
       :resource-url resource-url}
      map->Checkpoint
      (with-meta {:spec :checkpoint/valid})))

(defn blank [checkpoint-id]
  "creates a blank checkpoint"
  (-> {:checkpoint-id (str (random-uuid))
       :task ""
       :resource-url ""}
      map->Checkpoint
      (with-meta {:spec :offcourse/new-checkpoint})))
